<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include('../dbconn.php');

if (isset($_GET['subcategory_id'])) {

    $subcategory_id = intval($_GET['subcategory_id']);
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $limit = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 100;
    $offset = ($page - 1) * $limit;
    $search = isset($_GET['search']) ? trim($_GET['search']) : "";

    $response = [
        "success" => false,
        "message" => "No products found",
        "total_count" => 0,
        "page" => $page,
        "limit" => $limit,
        "data" => []
    ];

    /* ---------------------------------------
         COUNT QUERY
    --------------------------------------- */

    $count_query = "SELECT COUNT(*) as total FROM new_products WHERE sub_category_id = ?";
    $types_c = "i";
    $params_c = [$subcategory_id];

    if (!empty($search)) {
        $count_query .= " AND name LIKE ?";
        $types_c .= "s";
        $params_c[] = "%$search%";
    }

    $stmt_c = $conn->prepare($count_query);
    $stmt_c->bind_param($types_c, ...$params_c);
    $stmt_c->execute();
    $total_count = $stmt_c->get_result()->fetch_assoc()['total'];
    $stmt_c->close();

    /* ---------------------------------------
         MAIN FETCH QUERY
    --------------------------------------- */

    $sql = "SELECT * FROM new_products WHERE sub_category_id = ?";
    $types = "i";
    $params = [$subcategory_id];

    if (!empty($search)) {
        $sql .= " AND name LIKE ?";
        $types .= "s";
        $params[] = "%$search%";
    }

    // pagination
    $sql .= " LIMIT ? OFFSET ?";
    $types .= "ii";
    $params[] = $limit;
    $params[] = $offset;

    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();

    $products = [];

    /* ---------------------------------------
         PROCESS EACH PRODUCT
         FLATTEN SPECIFICATIONS JSON
    --------------------------------------- */

    while ($row = $result->fetch_assoc()) {

        // Decode specifications JSON
        $specs = [];
        if (!empty($row['specifications'])) {
            $specDecoded = json_decode($row['specifications'], true);
            if (is_array($specDecoded)) {
                $specs = $specDecoded;
            }
        }

        // Remove specifications JSON column
        unset($row['specifications']);

        // Add each spec to base object
        foreach ($specs as $key => $value) {
            $row[$key] = $value;
        }

        $products[] = $row;
    }

    $stmt->close();

    $response = [
        "success" => true,
        "message" => "Products fetched successfully",
        "total_count" => $total_count,
        "page" => $page,
        "limit" => $limit,
        "data" => $products
    ];

    echo json_encode($response);

} else {
    echo json_encode(["success" => false, "message" => "subcategory_id parameter is missing"]);
}

$conn->close();
?>
