<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../dbconn.php';

header("Access-Control-Allow-Origin: http://localhost:5173");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['id'])) {
    $product_id = intval($_GET['id']);

    $query = "SELECT 
                p.id,
                p.sku,
                p.weight,
                p.size,
                p.price,
                p.stock_quantity,
                p.image_url,
                p.width,
                p.height,
                p.slot_width,
                p.coating,
                p.is_default,
                p.in_stock,
                p.material,
                p.making,
                c.name as category_name,
                sc.name as subcategory_name
              FROM products p
              LEFT JOIN sub_categories sc ON p.sub_category_id = sc.id
              LEFT JOIN categories c ON sc.category_id = c.id
              WHERE p.id = ?";

    if ($stmt = $conn->prepare($query)) {
        $stmt->bind_param("i", $product_id);
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            if ($row = $result->fetch_assoc()) {
                echo json_encode(['status' => 'success', 'data' => $row]);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Product not found']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Query execution failed']);
        }
        $stmt->close();
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Query preparation failed']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
}

$conn->close();
?>
