<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

header("Content-Type: application/json");
require '../dbconn.php'; // Include database connection

$status_type = isset($_GET['status_type']) ? $_GET['status_type'] : '';

// Validate status_type input
$allowed_types = ['latest', 'best_seller', 'both'];
if (!empty($status_type) && !in_array($status_type, $allowed_types)) {
    echo json_encode(["success" => false, "message" => "Invalid status type"]);
    exit;
}

// Build query conditions
$conditions = [];
if ($status_type === 'latest') {
    $conditions[] = "p.is_latest = 1";
} elseif ($status_type === 'best_seller') {
    $conditions[] = "p.is_best_seller = 1";
} elseif ($status_type === 'both' || empty($status_type)) {
    // If no filter is provided, fetch both latest and best sellers
    $conditions[] = "(p.is_latest = 1 OR p.is_best_seller = 1)";
}

// Final query construction
$query = "SELECT p.id, p.sku, p.image_url, p.sub_category_id, p.price, p.stock_quantity, 
                 p.weight, p.size, p.width, p.height, p.slot_width, 
                 p.coating, p.is_default, p.in_stock, p.material, p.making, 
                 p.is_latest, p.is_best_seller,
                 s.name AS subcategory_name, 
                 c.name AS category_name 
          FROM products p
          LEFT JOIN sub_categories s ON p.sub_category_id = s.id
          LEFT JOIN categories c ON s.category_id = c.id";

if (!empty($conditions)) {
    $query .= " WHERE " . implode(" AND ", $conditions);
}

$result = $conn->query($query);

$latest_products = [];
$best_seller_products = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $product = [
            'id' => $row['id'],
            'sku' => $row['sku'],
            'image_url' => $row['image_url'],
            'sub_category_id' => $row['sub_category_id'],
            'subcategory_name' => $row['subcategory_name'],
            'category_name' => $row['category_name'],
            'price' => $row['price'],
            'stock_quantity' => $row['stock_quantity'],
            'weight' => $row['weight'],
            'size' => $row['size'],
            'width' => $row['width'],
            'height' => $row['height'],
            'slot_width' => $row['slot_width'],
            'coating' => $row['coating'],
            'is_latest' => $row['is_latest'],
            'is_best_seller' => $row['is_best_seller'],
            'is_default' => $row['is_default'],
            'in_stock' => $row['in_stock'],
            'material' => $row['material'],
            'making' => $row['making']
        ];

        if ($row['is_latest']) {
            $latest_products[] = $product;
        }
        if ($row['is_best_seller']) {
            $best_seller_products[] = $product;
        }
    }

    echo json_encode([
        "success" => true,
        "latest_products" => $latest_products,
        "best_seller_products" => $best_seller_products
    ]);
} else {
    echo json_encode(["success" => false, "message" => "No products found"]);
}
?>
