<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
header('Access-Control-Allow-Origin: http://localhost:5173');
// Allow all origins
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}
define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (!isset($user_id)) {
        echo json_encode(["success" => false, "error" => "Missing required field: user_id"]);
        exit;
    }

    //$user_id = intval($_POST['user_id']);

    $query = "SELECT pr.id, pr.product_id, p.name AS product_name, p.image_url, pr.id, pr.rating,pr.review_text, pr.created_at, pr.updated_at 
              FROM product_reviews pr
              JOIN products p ON pr.product_id = p.id
              WHERE pr.user_id = ?";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $reviews = [];
        while ($row = $result->fetch_assoc()) {
            $reviews[] = $row;
        }
        echo json_encode(["success" => true, "reviews" => $reviews]);
    } else {
        echo json_encode(["success" => false, "message" => "No reviews found for this user"]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
}

$conn->close();
?>
