<?php

// Set response headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    header("HTTP/1.1 200 OK");
    exit();
}

// header('Access-Control-Allow-Origin: http://localhost:5173');
// // Allow all origins
// header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); // Allow specific HTTP methods
// header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control'); // Allow specific headers
header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

try {
    // Validate required fields
    $required_fields = [ 'shipping_address_id', 'total_amount', 'payment_method', 'shipping_charges'];
    foreach ($required_fields as $field) {
        if (!isset($_POST[$field])) {
            throw new Exception("Missing required field: $field");
        }
    }

    // Parse items from form data (assumed to be JSON-encoded in the "items" field)
    if (!isset($_POST['items'])) {
        throw new Exception("Missing required field: items");
    }
    $items = json_decode($_POST['items'], true);
    if (!is_array($items) || empty($items)) {
        throw new Exception("Invalid items data");
    }

    // Start transaction
    $conn->begin_transaction();

    // Insert order with shipping charges
    $order_sql = "INSERT INTO orders (user_id, shipping_address_id, total_amount, shipping_charges, payment_method) 
                  VALUES (?, ?, ?, ?, ?)";
    $order_stmt = $conn->prepare($order_sql);
    $order_stmt->bind_param(
        "iidds",
        $user_id,
        $_POST['shipping_address_id'],
        $_POST['total_amount'],
        $_POST['shipping_charges'],
        $_POST['payment_method']
    );
    $order_stmt->execute();
    $order_id = $conn->insert_id;

    // Insert order items
    $items_sql = "INSERT INTO order_items (order_id, product_id, quantity, unit_price, total_price, shipping_charges) 
                  VALUES (?, ?, ?, ?, ?, ?)";
    $items_stmt = $conn->prepare($items_sql);

    foreach ($items as $item) {
        if (!isset($item['product_id'], $item['quantity'])) {
            throw new Exception("Missing required item fields (product_id, quantity)");
        }

        // Get product details and validate stock
        $product_sql = "SELECT price, stock_quantity , NAME FROM products WHERE id = ?";
        $product_stmt = $conn->prepare($product_sql);
        $product_stmt->bind_param("i", $item['product_id']);
        $product_stmt->execute();
        $product_result = $product_stmt->get_result()->fetch_object();
    
    
        if (!$product_result || $product_result->stock_quantity < $item['quantity']) {
            // throw new Exception("Product out of stock: " . $item['product_id']);
            echo json_encode([
                "success" => false,
                "message" => "Product out of stock: " . $product_result->NAME
            ]);
             exit;
        }

        // Calculate item total
        $unit_price = $product_result->price;
        $total_price = $unit_price * $item['quantity'];

        // Distribute shipping charges equally among items
        $item_shipping_charges = $_POST['shipping_charges'] / count($items);
    
        // Insert order item
        $items_stmt->bind_param("iiiddd", $order_id, $item['product_id'], $item['quantity'], $unit_price, $total_price, $item_shipping_charges);
        $items_stmt->execute();

        // Update product stock
        $update_stock_sql = "UPDATE products SET stock_quantity = stock_quantity - ? WHERE id = ?";
        $update_stock_stmt = $conn->prepare($update_stock_sql);
        $update_stock_stmt->bind_param("ii", $item['quantity'], $item['product_id']);
        $update_stock_stmt->execute();
    }

    // Commit transaction
    $conn->commit();
    
    // Clear temporary cart for the user
    $clear_cart_sql = "DELETE FROM temp_cart WHERE user_id = ?";
    $clear_cart_stmt = $conn->prepare($clear_cart_sql);
    $clear_cart_stmt->bind_param("i", $user_id);
    $clear_cart_stmt->execute();
    
    // Remove quotation associated with the user
    $delete_quote_sql = "DELETE FROM quotes WHERE user_id = ?";
    $delete_quote_stmt = $conn->prepare($delete_quote_sql);
    $delete_quote_stmt->bind_param("i", $user_id);
    $delete_quote_stmt->execute();

    // Return success response
    echo json_encode([
        'success' => true,
        'order_id' => $order_id,
        'message' => 'Order placed successfully and quotation removed'
    ]);

} catch (Exception $e) {
    // Rollback transaction on error
    if ($conn->connect_error === false) {
        $conn->rollback();
    }

    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

$conn->close();
?>
