<?php

header('Content-Type: application/json');
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;




$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        http_response_code(400); // Unauthorized
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    // Set headers for preflight response
    header("Access-Control-Allow-Origin: *"); // Allow any origin, or replace * with specific domains like "https://yourdomain.com"
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS"); // Allowed HTTP methods
    header("Access-Control-Allow-Headers: Content-Type, Authorization"); // Allowed headers
    header("Access-Control-Allow-Credentials: true"); // If you're sending cookies or HTTP authentication
    header("HTTP/1.1 200 OK"); // Optional, sets response status to 200
    exit(); // Stop the script here since no further action is needed
}
//require_once '../dbconn.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit();
}

try {
    //$user_id = isset($_POST['user_id) ? intval($_POST['user_id']) : null;
    
    if (!$user_id) {
        throw new Exception('User ID is required');
    }

    $query = "SELECT 
        o.id AS order_id,
        o.order_status,
        o.total_amount,
        o.payment_status,
        o.shipping_charges,
        o.payment_method,
        o.tracking_number,
        DATE_FORMAT(o.created_at, '%d-%m-%Y %h:%i %p') AS order_date,
        sa.first_name,
        sa.phone_number,
        sa.flat_building,
        sa.area_street,
        sa.landmark,
        sa.city,
        sa.state,
        sa.country
    FROM orders o
    JOIN shipping_addresses sa ON o.shipping_address_id = sa.id
    WHERE o.user_id = ?
    ORDER BY o.created_at DESC";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $orders = [];
    while ($order = $result->fetch_assoc()) {
        // Initialize items array for each order
        $order['items'] = [];
        
        // Get order items
        $items_query = "SELECT 
            oi.quantity,
            oi.unit_price,
            oi.total_price,
            p.name,
            p.image_url,
            p.sku,
            p.id as product_id
        FROM order_items oi
        JOIN products p ON oi.product_id = p.id
        WHERE oi.order_id = ?";
        
        $items_stmt = $conn->prepare($items_query);
        $items_stmt->bind_param("i", $order['order_id']);
        $items_stmt->execute();
        $items_result = $items_stmt->get_result();
        
        while ($item = $items_result->fetch_assoc()) {
            // Format item amounts
            $item['unit_price'] = number_format($item['unit_price'], 2);
            $item['total_price'] = number_format($item['total_price'], 2);
            $order['items'][] = $item;
        }
    
        $items_stmt->close(); // Close the statement for safety
    
        // Format total amount for the order
        $order['total_amount'] = number_format($order['total_amount'], 2);
    
        $orders[] = $order; // Add the order to the orders array
    }
    
    if (empty($orders)) {
        echo json_encode([
            'success' => true,
            'message' => 'No orders found',
            'orders' => []
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'orders' => $orders
        ]);
    }

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

$conn->close();
?>