<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include '../dbconn.php';

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["success" => false, "error" => "Invalid JSON data"]);
    exit;
}

// Update Support Number & About Us
if (isset($data["support_number"]) && isset($data["about_us"])) {
    $support_number = $data["support_number"];
    $about_us = $data["about_us"];

    $sql = "UPDATE settings SET support_number = ?, about_us = ? WHERE id = 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $support_number, $about_us);
    $stmt->execute();
}

// Handle FAQs (Update Existing & Add New)
if (isset($data["faqs"]) && is_array($data["faqs"])) {
    foreach ($data["faqs"] as $faq) {
        if (isset($faq["id"])) {
            // Update Existing FAQ
            $faq_id = $faq["id"];
            $question = $faq["question"];
            $answer = $faq["answer"];

            $sql = "UPDATE faqs SET question = ?, answer = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ssi", $question, $answer, $faq_id);
            $stmt->execute();
        } else {
            // Insert New FAQ
            $question = $faq["question"];
            $answer = $faq["answer"];

            $sql = "INSERT INTO faqs (question, answer) VALUES (?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("ss", $question, $answer);
            $stmt->execute();
        }
    }
}

echo json_encode(["success" => true, "message" => "Support number, about us, and FAQs updated"]);
?>
