<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include '../dbconn.php';

header("Content-Type: application/json");

// Check if faq_id is provided in form data
if (!isset($_POST["faq_id"])) {
    echo json_encode(["success" => false, "error" => "Missing faq_id"]);
    exit;
}

// Extract FAQ ID
$faq_id = $_POST["faq_id"];

// Prepare and execute the DELETE statement
$sql = "DELETE FROM faqs WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $faq_id);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "FAQ deleted successfully"]);
} else {
    echo json_encode(["success" => false, "error" => "Failed to delete FAQ"]);
}

// Close the connection
$stmt->close();
$conn->close();
?>
