<?php
// Include database connection
require '../dbconn.php';
require_once '../vendor/autoload.php';
require '../env.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;


$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

if (!$authHeader || !str_starts_with($authHeader, 'Bearer ')) {
    echo json_encode(['status' => 'error', 'message' => 'Authorization token missing']);
    exit;
}

$token = str_replace('Bearer ', '', $authHeader);
//$secretKey = "e3ff5f077839c1331b1d893a728246685cb7dba9e3a77bffe7d52eaccf660988";

try {
    $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
    $user_id = $decoded->sub ?? null; // Extract user ID from token
    if (!$user_id) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid token: user ID not found']);
        exit;
    }
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Token error: ' . $e->getMessage()]);
    exit;
}


// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    //$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : null;
    $product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : null;
    $quantity = isset($_POST['quantity']) ? intval($_POST['quantity']) : 1;
    $unit_price = isset($_POST['unit_price']) ? floatval($_POST['unit_price']) : null;

    // Validate input data
    if (!$user_id || !$product_id || !$unit_price) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Missing required fields: user_id, product_id, or unit_price.',
        ]);
        exit;
    }

    // Check if the product already exists in the user's cart
    $query = "SELECT id, quantity FROM temp_cart WHERE user_id = ? AND product_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ii", $user_id, $product_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // If product exists, update the quantity
        $row = $result->fetch_assoc();
        $new_quantity = $row['quantity'] + $quantity;

          // check stock quantity 
            $query = "SELECT stock_quantity FROM products WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $product_id);
            $stmt->execute();
            $result = $stmt->get_result();

             if ($result->num_rows > 0){
                $data = $result->fetch_assoc();
                if($data['stock_quantity'] < $new_quantity){
                echo json_encode([
                'status' => 'error',
                'message' => "Sorry, you already have {$data['stock_quantity']} items in your cart. Please adjust the quantity within the available stock limit.",

                ]);
            exit;
            }
             }

        $update_query = "UPDATE temp_cart SET quantity = ? WHERE id = ?";
        $update_stmt = $conn->prepare($update_query);
        $update_stmt->bind_param("ii", $new_quantity, $row['id']);
        if ($update_stmt->execute()) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Cart updated successfully.',
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update cart.',
            ]);
        }
    } else {
        // If product does not exist, insert a new entry
        $insert_query = "INSERT INTO temp_cart (user_id, product_id, quantity, unit_price) VALUES (?, ?, ?, ?)";
        $insert_stmt = $conn->prepare($insert_query);
        $insert_stmt->bind_param("iiid", $user_id, $product_id, $quantity, $unit_price);
        if ($insert_stmt->execute()) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Product added to cart successfully.',
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to add product to cart.',
            ]);
        }
    }

    $stmt->close();
    $conn->close();
} else {
    // Handle invalid request method
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method. Use POST.',
    ]);
}
