<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require('../dbconn.php'); // Include your DB connection

// Set headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    $targetDir = "../uploads/"; // Folder to store images
    $fileName = basename($_FILES["image"]["name"]);
    $targetFilePath = $targetDir . time() . "_" . $fileName;
    $fileType = strtolower(pathinfo($targetFilePath, PATHINFO_EXTENSION));

    // Allowed file types
    $allowedTypes = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    if (in_array($fileType, $allowedTypes)) {
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $targetFilePath)) {
            // Remove first two characters '../' from path before storing
            $dbFilePath = substr($targetFilePath, 2); // Removes '../'
            // Store path in DB
             $query = "INSERT INTO banners (image_path) VALUES (?)";
            if ($stmt = $conn->prepare($query)) {
                $stmt->bind_param("s", $dbFilePath);
                if ($stmt->execute()) {
                    echo json_encode(["status" => "success", "message" => "Image uploaded!", "image_url" => $dbFilePath]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Failed to insert in DB"]);
                }
                $stmt->close();
            }
        } else {
            echo json_encode(["status" => "error", "message" => "File upload failed!"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Invalid file type!"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "No image received"]);
}

$conn->close();
?>
