<?php
// Include the database connection
include '../dbconn.php';

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve the identifier (mobile or email) and OTP from the form data
    $identifier = $_POST['identifier'] ?? null; // Can be mobile or email
    $otp = $_POST['otp'] ?? null;

    // Initialize the response
    $response = [
        "status" => "error",
        "message" => "Invalid identifier or OTP."
    ];

    // Validate the identifier and OTP
    if (!$identifier || (!$otp || !preg_match('/^\d{4}$/', $otp))) {
        $response['message'] = "Invalid identifier or OTP format. Please provide valid inputs.";
        echo json_encode($response);
        exit;
    }

    // Determine if the identifier is a mobile number or email
    if (preg_match('/^\d{10}$/', $identifier)) {
        
        
        $valid_duration = 5 * 60; // 5 minutes in seconds
        
        // 1️⃣ Prepare query to get OTP info
        $query = "SELECT otp, created_at FROM otp_store WHERE mobile = ? ORDER BY created_at DESC LIMIT 1";
        
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $identifier);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            // No OTP found for this mobile/email
            echo json_encode(["status" =>false, "message" => "No OTP found"]);
            exit;
        }
        
        $row = $result->fetch_assoc();
        $stored_otp = $row['otp'];
        $created_at = strtotime($row['created_at']); // convert datetime to timestamp
        $current_time = time();
        
        // 2️⃣ Check if OTP is expired
        if (($current_time - $created_at) > $valid_duration) {
            echo json_encode(["status" =>false, "message" => "OTP expired"]);
            exit;
        }
        
        // 3️⃣ Check if OTP matches
        if ($otp != $stored_otp) {
            echo json_encode(["status" =>false, "message" => "Invalid OTP"]);
            exit;
        }
        
        // ✅ OTP is valid and not expired
        echo json_encode(["status" => 'success', "message" => "OTP verified successfully"]);
        
        // Optional: Delete OTP after successful verification
        $delQuery = "DELETE FROM otp_store WHERE mobile = ?";
        $delStmt = $conn->prepare($delQuery);
        $delStmt->bind_param("s", $identifier);
        $delStmt->execute();
        exit;
    } elseif (filter_var($identifier, FILTER_VALIDATE_EMAIL)) {
        // Email logic
        $query = "SELECT otp, created_at FROM otp_store WHERE email = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("s", $identifier);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $row = $result->fetch_assoc();

            // Validate the OTP and expiration
            $storedOtp = $row['otp'];
            $createdAt = strtotime($row['created_at']);
            $currentTime = time();
            $expiryTime = 5 * 60; // OTP valid for 5 minutes

            if ($otp == $storedOtp) {
                if (($currentTime - $createdAt) <= $expiryTime) {
                    // Mark the email as verified (if applicable)
                    $updateQuery = "UPDATE users SET is_verified = 1 WHERE email = ?";
                    $updateStmt = $conn->prepare($updateQuery);
                    $updateStmt->bind_param("s", $identifier);
                    $updateStmt->execute();

                    // Respond with success
                    $response = [
                        "status" => "success",
                        "message" => "Email verified successfully."
                    ];
                } else {
                    $response['message'] = "The OTP has expired. Please request a new one.";
                }
            } else {
                $response['message'] = "Incorrect OTP for email.";
            }
        } else {
            $response['message'] = "No OTP found for the provided email.";
        }
        $stmt->close();
    } else {
        $response['message'] = "Invalid identifier. Must be a 10-digit mobile number or a valid email.";
    }

    // Output the response
    echo json_encode($response);
    $conn->close();
} else {
    // Return error if the request method is not POST
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Use POST."
    ]);
}
?>
