<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Allow CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Set the time zone to Asia/Kolkata
date_default_timezone_set('Asia/Kolkata');

// Include the database connection and email script
include '../dbconn.php';
include 'email.php';


// OTP SEND FUNCTION 
 function sendMobileOTP($mobile,$randomString){
        // $message='Your One Time Password (OTP) for Gaswala is '.$randomString.'    '.$hash.' - VERAMASA';
        // $message ='Dear User, Your OTP for GASWALE  is '.$randomString.'. Valid for 5 minutes. Please do not share this OTP.';
        
        $message = 'Dear User, your OTP for Login is '.$randomString.'. Please use this OTP to complete the process. Do not share it with anyone. BoltKart';
        $xml_data ='<?xml version="1.0"?>
			<parent>
			<child>
			<user>boltkart</user>
			<key>a03fe48d07XX</key>
			<mobile>' . $mobile . '</mobile>
			<message>' . $message . '</message>
			<accusage>1</accusage>
		    <senderid>BOLTKR</senderid>
			<entityid>1401473620000075950</entityid>
            <tempid>1407175973560667871</tempid>
			</child>
			</parent>';

			$URL = "http://sms.bulkssms.com/submitsms.jsp?"; 

			$ch = curl_init($URL);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
			curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/xml'));
			curl_setopt($ch, CURLOPT_POSTFIELDS, "$xml_data");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			$output = curl_exec($ch);
			curl_close($ch);
		  //  print_r($output);
			 //$result=explode(",",$output);
        	$result = preg_split("/\,/",$output);
        	$status = trim($result[0]);
			if($status=='sent'){$rtn = array('success'=>true,'otp'=>$randomString); }
			else{$rtn = array('success'=>false,'otp'=>'');}
			return $rtn;
    }

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve the input from the form data
    $input = $_POST['input'] ?? null;

    // Initialize the response
    $response = [
        "status" => "error",
        "message" => "Invalid input. Please provide a valid mobile number or email."
    ];

    // Validate the input
    $isMobile = $input && preg_match('/^\d{10}$/', $input); // 10-digit mobile number
    $isEmail = $input && filter_var($input, FILTER_VALIDATE_EMAIL); // Valid email

    if ($isMobile) {
        $identifier = "mobile";
        $mobile = $input;
        $email = null;
    } elseif ($isEmail) {
        $identifier = "email";
        $email = $input;
        $mobile = null;
    } else {
        // If the input is invalid, return an error
        $response['message'] = "Invalid mobile number or email format.";
        echo json_encode($response);
        exit;
    }
    
    // **Check if the mobile number is already registered in the users table**
    if ($identifier === "mobile") {
        $checkUserQuery = "SELECT id FROM users WHERE mobile = ?";
        $stmt = $conn->prepare($checkUserQuery);
        $stmt->bind_param("s", $mobile);
        $stmt->execute();
        $userResult = $stmt->get_result();

        if ($userResult->num_rows > 0) {
            $response['message'] = "The mobile number is already registered.";
            echo json_encode($response);
            exit;
        }
    }

    // Check if an OTP has already been sent in the last 60 seconds
    $query = $identifier === "mobile"
        ? "SELECT created_at FROM otp_store WHERE mobile = ?"
        : "SELECT created_at FROM otp_store WHERE email = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $input);
    $stmt->execute();
    $result = $stmt->get_result();

    $currentTime = time(); // Current timestamp
    $canResendAfter = 60; // 60 seconds interval for resending

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        $lastCreatedAt = strtotime($row['created_at']); // Convert database time to timestamp

        // Check if the resend request is within the allowed interval
        if (($currentTime - $lastCreatedAt) < $canResendAfter) {
            $response['message'] = "You can request a new OTP after " . ($canResendAfter - ($currentTime - $lastCreatedAt)) . " seconds.";
            echo json_encode($response);
            exit;
        }
    }

    // Generate OTP
    $otp = rand(1000, 9999);

    // Insert or update OTP in the database
    $query = "INSERT INTO otp_store (mobile, email, otp, created_at) 
              VALUES (?, ?, ?, NOW())
              ON DUPLICATE KEY UPDATE 
              otp = VALUES(otp), 
              created_at = VALUES(created_at)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssi", $mobile, $email, $otp);

    if ($stmt->execute()) {
        // Send OTP based on the identifier
        if ($identifier === "email") {
            $subject = "Your OTP Code";
            $output = "Your OTP code is: $otp. Please use this to verify your account.";
            $emailSent = forgotpassword($email, $output, $subject);
            if ($emailSent) {
                $response = [
                    "status" => "success",
                    "message" => "OTP sent successfully to the provided email.",
                ];
            } else {
                $response['message'] = "Failed to send OTP via email. Please try again.";
            }
        } elseif ($identifier === "mobile") {
            // Simulated SMS sending logic here
            
            
            // OTP SEDNING API
           if (function_exists('sendMobileOTP')) {
            sendMobileOTP($input, $otp);
        }   
            
            $response = [
                "status" => "success",
                "message" => "OTP sent successfully to the provided mobile number.",
                "otp" => $otp // Include OTP in response for testing
            ];
        }
    } else {
        $response['message'] = "Failed to send OTP. Please try again later.";
    }

    echo json_encode($response);
    $stmt->close();
    $conn->close();
} else {
    // Return error if the request method is not POST
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Use POST."
    ]);
}
