<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
// Include the database connection
include '../dbconn.php';
date_default_timezone_set('Asia/Kolkata');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve the input from the form data
    $input = $_POST['input'] ?? null;

    // Initialize the response
    $response = [
        "status" => "error",
        "message" => "Failed to resend OTP. Please try again later."
    ];

    // Validate the input
    $isMobile = $input && preg_match('/^\d{10}$/', $input); // 10-digit mobile number
    $isEmail = $input && filter_var($input, FILTER_VALIDATE_EMAIL); // Valid email

    if ($isMobile) {
        $identifier = "mobile";
        $mobile = $input;
        $email = null;
    } elseif ($isEmail) {
        $identifier = "email";
        $email = $input;
        $mobile = null;
    } else {
        // Invalid input format
        $response['message'] = "Invalid input format. Please provide a valid 10-digit mobile number or email address.";
        echo json_encode($response);
        exit;
    }

    // Generate a 4-digit OTP (for testing, use a fixed OTP like '1234')
    $otp = rand(1000, 9999);

    // Check if an OTP already exists for the input
    $query = $identifier === "mobile"
        ? "SELECT created_at FROM otp_store WHERE mobile = ?"
        : "SELECT created_at FROM otp_store WHERE email = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $input);
    $stmt->execute();
    $result = $stmt->get_result();

    
    $currentTime = date("Y-m-d H:i:s");
    
    $canResendAfter = 60; // 1-minute interval for resending

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        $lastCreatedAt = strtotime($row['created_at']);

        // Check if the resend request is within the allowed interval
        if (($currentTime - $lastCreatedAt) < $canResendAfter) {
            $response['message'] = "You can request a new OTP after 1 minute.";
            $response['debug'] = [
                "current_time" => date("Y-m-d H:i:s", strtotime($currentTime)), // Current server time
                "created_at" => $row['created_at'], // Timestamp from the database
                "time_difference" => $currentTime - $lastCreatedAt, // Difference in seconds
            ];
            echo json_encode($response);
            exit;
        }

        // Update the existing OTP
        $updateQuery = $identifier === "mobile"
            ? "UPDATE otp_store SET otp = ?, created_at = NOW() WHERE mobile = ?"
            : "UPDATE otp_store SET otp = ?, created_at = NOW() WHERE email = ?";
        $updateStmt = $conn->prepare($updateQuery);
        $updateStmt->bind_param("is", $otp, $input);
        $updateSuccess = $updateStmt->execute();
    } else {
        // Insert a new OTP record
        $insertQuery = $identifier === "mobile"
            ? "INSERT INTO otp_store (mobile, otp, created_at) VALUES (?, ?, NOW())"
            : "INSERT INTO otp_store (email, otp, created_at) VALUES (?, ?, NOW())";
        $insertStmt = $conn->prepare($insertQuery);
        $insertStmt->bind_param("si", $input, $otp);
        $insertSuccess = $insertStmt->execute();
    }

    // Check if the OTP was successfully stored
    if (isset($updateSuccess) && $updateSuccess || isset($insertSuccess) && $insertSuccess) {
        if ($identifier === "email") {
            // Simulate email sending
            $subject = "Your Resend OTP Code";
            $output = "Your OTP code is: $otp. Please use this to proceed.";
            $emailSent = forgotpassword($email, $output, $subject);

            if ($emailSent) {
                $response = [
                    "status" => "success",
                    "message" => "OTP resent successfully to the provided email.",
                ];
            } else {
                $response['message'] = "Failed to resend OTP via email. Please try again.";
            }
        } elseif ($identifier === "mobile") {
            // Simulate SMS sending (add your logic here)
            $response = [
                "status" => "success",
                "message" => "OTP resent successfully to the provided mobile number.",
                "otp" => $otp // Include OTP in response for testing (remove in production)
            ];
        }
    }

    // Output the response
    echo json_encode($response);
    $stmt->close();
    $conn->close();
} else {
    // Return error if the request method is not POST
    echo json_encode([
        "status" => "error",
        "message" => "Invalid request method. Use POST."
    ]);
}
?>
