<?php
// Include the database connection
include '../dbconn.php';

// Extract form data
$name = $_POST['name'] ?? null;
$organisation = $_POST['organisation'] ?? null;
$designation = $_POST['designation'] ?? null;
$email = $_POST['email'] ?? null;
$mobile = $_POST['mobile'] ?? null;
$password = $_POST['password'] ?? null;
$confirm_password = $_POST['confirm_password'] ?? null;

// Initialize response
$response = [
    "status" => "error",
    "message" => "An unexpected error occurred."
];

// Validate input
if (!$name || !$organisation || !$designation || !$mobile || !$password || !$confirm_password) {
    $response['message'] = "All fields are required.";
    echo json_encode($response);
    exit;
}

// Validate email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $response['message'] = "Invalid email format.";
    echo json_encode($response);
    exit;
}

// Validate password match
if ($password !== $confirm_password) {
    $response['message'] = "Password and Confirm Password do not match.";
    echo json_encode($response);
    exit;
}

// Check if the email is already registered
$query = "SELECT id FROM users WHERE email = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $response['message'] = "Email is already registered.";
    echo json_encode($response);
    exit;
}

// Check if the mobile number is already registered
$query = "SELECT id FROM users WHERE mobile = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $mobile);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $response['message'] = "Mobile number is already registered.";
    echo json_encode($response);
    exit;
}

// Here, include the check for mobile number verification (this depends on your OTP verification implementation)
$is_verified = true; // Simulated for demonstration
if (!$is_verified) {
    $response['message'] = "Mobile number not verified.";
    echo json_encode($response);
    exit;
}

// Hash the password before saving it in the database
$hashed_password = password_hash($password, PASSWORD_BCRYPT);

// Insert user into the database
$insert_query = "INSERT INTO users (name, organisation, designation, email, mobile, password_hash) VALUES (?, ?, ?, ?, ?, ?)";
$insert_stmt = $conn->prepare($insert_query);
$insert_stmt->bind_param("ssssss", $name, $organisation, $designation, $email, $mobile, $hashed_password);

if ($insert_stmt->execute()) {
    $response['status'] = "success";
    $response['message'] = "Registration completed successfully.";
} else {
    $response['message'] = "Failed to register user. Please try again.";
}

// Output the response
echo json_encode($response);

// Close the database connection
$conn->close();
?>
