<?php
include '../../dbconn.php'; // Database connection

header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
    exit;
}

// Validate required field
if (!isset($_POST['id']) || empty($_POST['id'])) {
    echo json_encode(["success" => false, "message" => "ID is required"]);
    exit;
}

$id = intval($_POST['id']);

// Check if the promocode exists
$check_query = "SELECT * FROM promocodes WHERE id = ?";
$stmt = $conn->prepare($check_query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "message" => "Promocode not found"]);
    exit;
}

// Delete promocode
$delete_query = "DELETE FROM promocodes WHERE id = ?";
$stmt = $conn->prepare($delete_query);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Promocode deleted successfully"]);
} else {
    echo json_encode(["success" => false, "message" => "Failed to delete promocode"]);
}

$stmt->close();
$conn->close();
?>
