<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') { // Use POST instead of PUT for multipart/form-data
    if (isset($_POST['id']) && isset($_POST['category_id']) && isset($_POST['name']) && isset($_POST['description'])) {
        $id = intval($_POST['id']);
        $category_id = intval($_POST['category_id']);
        $name = mysqli_real_escape_string($conn, $_POST['name']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        $updated_at = date('Y-m-d H:i:s');

        // Handle Image Upload
        $image_url = "";
        if (!empty($_FILES['image']['name'])) {
            $target_dir = "uploads/";
            $image_name = basename($_FILES["image"]["name"]);
            $target_file = $target_dir . time() . "_" . $image_name;
            
            if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
                $image_url = "/Admin/products/" . $target_file;
            } else {
                echo json_encode([
                    "success" => false,
                    "error" => "Failed to upload image"
                ]);
                exit;
            }
        }

        // Construct query dynamically
        if ($image_url) {
            $query = "UPDATE sub_categories SET category_id = ?, name = ?, description = ?, image_url = ?, updated_at = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("issssi", $category_id, $name, $description, $image_url, $updated_at, $id);
        } else {
            $query = "UPDATE sub_categories SET category_id = ?, name = ?, description = ?, updated_at = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("isssi", $category_id, $name, $description, $updated_at, $id);
        }

        if ($stmt->execute() && $stmt->affected_rows > 0) {
            echo json_encode([
                "success" => true,
                "id" => $id,
                "category_id" => $category_id,
                "name" => $name,
                "image_url" => $image_url ?: "",
                "description" => $description,
                "updated_at" => $updated_at
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "error" => "Failed to update sub-category or no changes made"
            ]);
        }

        $stmt->close();
    } else {
        echo json_encode([
            "success" => false,
            "error" => "Missing required fields"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "error" => "Invalid request method"
    ]);
}

$conn->close();
?>
