<?php
header("Content-Type: application/json");
require_once '../dbconn.php';

// Allow CORS
// header("Access-Control-Allow-Origin: http://localhost:3000");
// header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
// header("Access-Control-Allow-Headers: Content-Type, Authorization");

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (isset($_POST['id']) && isset($_POST['name']) && isset($_POST['description'])) {
        
        $id = intval($_POST['id']);
        $name = mysqli_real_escape_string($conn, $_POST['name']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        $updated_at = date('Y-m-d H:i:s');
        
        $image_url = "";
        if (isset($_FILES['image'])) {
            $target_dir = "uploads/";
            $image_name = basename($_FILES["image"]["name"]);
            $target_file = $target_dir . time() . "_" . $image_name;
            
            if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
                $image_url = "/Admin/products/" . $target_file;
            } else {
                echo json_encode([
                    "success" => false,
                    "error" => "Failed to upload image"
                ]);
                exit;
            }
        }
        
        // Construct SQL query based on whether an image is uploaded
        if (!empty($image_url)) {
            $query = "UPDATE categories SET name = ?, description = ?, updated_at = ?, image_url = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("ssssi", $name, $description, $updated_at, $image_url, $id);
        } else {
            $query = "UPDATE categories SET name = ?, description = ?, updated_at = ? WHERE id = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("sssi", $name, $description, $updated_at, $id);
        }
        
        if ($stmt->execute() && $stmt->affected_rows > 0) {
            echo json_encode([
                "success" => true,
                "id" => $id,
                "name" => $name,
                "image_url" => $image_url ? $target_file : "",
                "description" => $description,
                "updated_at" => $updated_at
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "error" => "Failed to update category or no changes made"
            ]);
        }
        
        $stmt->close();
    } else {
        echo json_encode([
            "success" => false,
            "error" => "Missing required fields"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "error" => "Invalid request method"
    ]);
}

$conn->close();
?>
