<?php
// Include the database connection file
require '../dbconn.php';

// Handle CORS
// header('Access-Control-Allow-Origin: http://localhost:5174');
// header('Access-Control-Allow-Origin: http://localhost:5173');
// header('Access-Control-Allow-Origin: http://localhost:3000');
// header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
// header('Access-Control-Allow-Headers: Content-Type, Authorization, Cache-Control');

// Respond to OPTIONS preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Set response content type
header('Content-Type: application/json');

// Initialize response
$response = [];

// Get pagination parameters from query string
$page = isset($_GET['page']) ? intval($_GET['page']) : 1; // Default page = 1
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10; // Default limit = 10
$offset = ($page - 1) * $limit; // Calculate offset

// Get search query if provided
$search = isset($_GET['search']) ? trim($_GET['search']) : "";

// Count total categories
$count_query = "SELECT COUNT(*) as total FROM categories";
$count_result = $conn->query($count_query);
$total_count = $count_result->fetch_assoc()['total'];

// Fetch categories from the database with pagination and optional search
$sql = "SELECT id, name, image_url, description FROM categories";
if (!empty($search)) {
    $sql .= " WHERE name LIKE ?";
}
$sql .= " LIMIT ? OFFSET ?";

$stmt = $conn->prepare($sql);

if (!empty($search)) {
    $search_param = "%" . $search . "%";
    $stmt->bind_param("sii", $search_param, $limit, $offset);
} else {
    $stmt->bind_param("ii", $limit, $offset);
}

$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Fetch all rows as an associative array
    $categories = [];
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row;
    }
    // Success response
    $response = [
        'status' => 'success',
        'total_count' => $total_count,
        'page' => $page,
        'limit' => $limit,
        'data' => $categories
    ];
} else {
    // No categories found
    $response = [
        'status' => 'error',
        'message' => 'No categories found',
        'total_count' => $total_count
    ];
}

// Close the database connection
$stmt->close();
$conn->close();

// Output the response in JSON format
echo json_encode($response);
?>
