<?php
header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (isset($_POST['id'])) {
        $id = intval($_POST['id']);
        
        $query = "UPDATE sub_categories SET deleted = 1 WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("i", $id);
        
        if ($stmt->execute() && $stmt->affected_rows > 0) {
            echo json_encode([
                "success" => true,
                "message" => "Sub-category deleted successfully"
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "error" => "Failed to delete sub-category or not found"
            ]);
        }
        
        $stmt->close();
    } else {
        echo json_encode([
            "success" => false,
            "error" => "Missing required fields"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "error" => "Invalid request method"
    ]);
}

$conn->close();
?>
