<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (!isset($_POST['id'])) {
        echo json_encode(["success" => false, "error" => "Missing required field: id"]);
        exit;
    }

    $id = intval($_POST['id']);

    // Check if the product exists
    $checkQuery = "SELECT image_url FROM products WHERE id = ?";
    $stmt = $conn->prepare($checkQuery);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 0) {
        echo json_encode(["success" => false, "error" => "Product not found"]);
        exit;
    }

    $stmt->bind_result($image_url);
    $stmt->fetch();
    $stmt->close();

    // Delete the product
    $query = "DELETE FROM products WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        // Optionally, delete the associated image file
        if (!empty($image_url) && file_exists($image_url)) {
            unlink($image_url);
        }

        echo json_encode(["success" => true, "message" => "Product deleted successfully"]);
    } else {
        echo json_encode(["success" => false, "error" => "Failed to delete product"]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "error" => "Invalid request method"]);
}

$conn->close();
?>
