<?php
header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (isset($_POST['category_id']) && isset($_POST['name']) && isset($_POST['description'])) {
        $category_id = intval($_POST['category_id']);
        $name = mysqli_real_escape_string($conn, $_POST['name']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        $created_at = date('Y-m-d H:i:s');
        
        $image_url = "";
        if (isset($_FILES['image'])) {
            $target_dir = "uploads/";
            $image_name = basename($_FILES["image"]["name"]);
            $target_file = $target_dir . time() . "_" . $image_name;
            
            if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
                $image_url = "/Admin/products/" . $target_file;
            } else {
                echo json_encode([
                    "success" => false,
                    "error" => "Failed to upload image"
                ]);
                exit;
            }
        }
        
        $query = "INSERT INTO sub_categories (category_id, name, image_url, description, created_at) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("issss", $category_id, $name, $image_url, $description, $created_at);
        
        if ($stmt->execute()) {
            echo json_encode([
                "success" => true,
                "id" => $stmt->insert_id,
                "category_id" => $category_id,
                "name" => $name,
                "image_url" => $image_url,
                "description" => $description,
                "created_at" => $created_at
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "error" => "Failed to add sub-category"
            ]);
        }
        
        $stmt->close();
    } else {
        echo json_encode([
            "success" => false,
            "error" => "Missing required fields"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "error" => "Invalid request method"
    ]);
}

$conn->close();
?>
