<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require_once '../dbconn.php';

define("HTTP_METHOD", $_SERVER['REQUEST_METHOD']);

if (HTTP_METHOD === 'POST') {
    if (isset($_POST['name']) && isset($_FILES['image']) && isset($_POST['description'])) {
        
        $name = mysqli_real_escape_string($conn, $_POST['name']);
        $description = mysqli_real_escape_string($conn, $_POST['description']);
        $created_at = date('Y-m-d H:i:s');
        $updated_at = $created_at;
        
        // Handling Image Upload
        $target_dir = "uploads/";
        $image_name = basename($_FILES["image"]["name"]);
        $target_file = $target_dir . time() . "_" . $image_name;
        
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            $image_url = "/Admin/products/" . $target_file;
        } else {
            echo json_encode([
                "success" => false,
                "error" => "Failed to upload image"
            ]);
            exit;
        }
        
        // Insert Data into Database
        $query = "INSERT INTO categories (name, image_url, description, created_at, updated_at) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("sssss", $name, $image_url, $description, $created_at, $updated_at);
        
        if ($stmt->execute()) {
            $id = $stmt->insert_id;
            echo json_encode([
                "success" => true,
                "id" => $id,
                "name" => $name,
                "image_url" => $image_url,
                "description" => $description,
                "created_at" => $created_at
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "error" => "Failed to insert category"
            ]);
        }
        
        $stmt->close();
    } else {
        echo json_encode([
            "success" => false,
            "error" => "Missing required fields"
        ]);
    }
} else {
    echo json_encode([
        "success" => false,
        "error" => "Invalid request method"
    ]);
}

$conn->close();
?>
