<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json");
require '../dbconn.php';

define("METHOD", $_SERVER['REQUEST_METHOD']);
if (METHOD !== 'POST') {
    echo json_encode(["success" => false, "error" => "Invalid method"]);
    exit;
}

/* ---------------------------------------------------------
   EXTRACT FIELDS DIRECTLY FROM $_POST
--------------------------------------------------------- */

$id = isset($_POST['id']) ? intval($_POST['id']) : null;               // For update
$main_product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : null; // For variant

$sub_category_id = intval($_POST['sub_category_id']);
$sku = mysqli_real_escape_string($conn, $_POST['sku']);
$name = mysqli_real_escape_string($conn, $_POST['name']);
$description = mysqli_real_escape_string($conn, $_POST['description']);
$price = floatval($_POST['price']);
$stock_quantity = intval($_POST['stock_quantity']);
$is_default = isset($_POST['is_default']) ? intval($_POST['is_default']) : 0;

$specifications = "{}";
if (!empty($_POST['specifications'])) {
    // Validate JSON
    if (json_decode($_POST['specifications']) !== null) {
        $specifications = $_POST['specifications'];
    }
}

$updated_at = date("Y-m-d H:i:s");

$image_url = null;

/* ---------------------------------------------------------
   IMAGE HANDLING LOGIC
--------------------------------------------------------- */

if ($id) {
    // FETCH OLD IMAGE FOR UPDATE CASE
    $res = $conn->query("SELECT image_url FROM new_products WHERE id = $id");
    $old = $res->fetch_assoc();
    $old_image = $old['image_url'];

    if (empty($_FILES['image']['name'])) {
        $image_url = $old_image; // KEEP OLD
    }
}

// VARIANT CASE: COPY PARENT IMAGE
if ($main_product_id && !$id) {
    $res = $conn->query("SELECT image_url FROM new_products WHERE id = $main_product_id");
    $parent = $res->fetch_assoc();
    $image_url = $parent['image_url'];
}

// IF NEW IMAGE IS UPLOADED, USE IT
if (!empty($_FILES['image']['name'])) {
    $folder = "uploads/";
    $filename = time() . "_" . basename($_FILES['image']['name']);
    $filepath = $folder . $filename;

    if (move_uploaded_file($_FILES['image']['tmp_name'], $filepath)) {
        $image_url = "/Admin/new_products/" . $filepath;
    } else {
        echo json_encode(["success" => false, "error" => "Image upload failed"]);
        exit;
    }
}

/* ---------------------------------------------------------
   UPDATE EXISTING PRODUCT
--------------------------------------------------------- */

if ($id) {
    $query = "UPDATE new_products SET 
                sub_category_id=?, 
                sku=?, 
                name=?, 
                description=?, 
                price=?, 
                stock_quantity=?, 
                specifications = CAST(? AS JSON),
                is_default=?, 
                updated_at=?, 
                image_url=?
              WHERE id=?";

    $stmt = $conn->prepare($query);
    $stmt->bind_param(
        "isssdissssi",
        $sub_category_id, $sku, $name, $description,
        $price, $stock_quantity, $specifications,
        $is_default, $updated_at, $image_url, $id
    );

    if ($stmt->execute()) {
        echo json_encode([
            "success" => true,
            "message" => "Product updated successfully",
            "id" => $id
        ]);
    } else {
        echo json_encode(["success" => false, "error" => $stmt->error]);
    }
    exit;
}

/* ---------------------------------------------------------
   INSERT NEW PRODUCT OR NEW VARIANT
--------------------------------------------------------- */

$query = "INSERT INTO new_products 
    (sub_category_id, sku, name, description, price, stock_quantity, specifications, image_url, is_default, updated_at)
    VALUES (?, ?, ?, ?, ?, ?, CAST(? AS JSON), ?, ?, ?)";

$stmt = $conn->prepare($query);
$stmt->bind_param(
    "isssdissss",
    $sub_category_id, $sku, $name, $description,
    $price, $stock_quantity, $specifications,
    $image_url, $is_default, $updated_at
);

if (!$stmt->execute()) {
    echo json_encode(["success" => false, "error" => $stmt->error]);
    exit;
}

$new_id = $stmt->insert_id;

echo json_encode([
    "success" => true,
    "message" => $main_product_id ? "Variant added" : "Product created",
    "product_id" => $new_id
]);

?>
