<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include '../dbconn.php';

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(["success" => false, "error" => "Order ID is required"]);
    exit;
}

$order_id = (int)$_GET['id'];

$sql = "SELECT orders.*, users.id AS user_id, users.name, users.email, users.mobile,
               shipping_addresses.first_name, shipping_addresses.last_name, shipping_addresses.phone_number,
               shipping_addresses.flat_building, shipping_addresses.area_street, shipping_addresses.landmark,
               shipping_addresses.city, shipping_addresses.state, shipping_addresses.country, shipping_addresses.pincode
        FROM orders
        JOIN users ON orders.user_id = users.id
        JOIN shipping_addresses ON orders.shipping_address_id = shipping_addresses.id
        WHERE orders.id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["success" => false, "error" => "Order not found"]);
    exit;
}

$order = $result->fetch_assoc();

$sql_items = "SELECT order_items.id, order_items.quantity, order_items.unit_price, order_items.total_price,
                     products.id AS product_id, products.name AS product_name, products.sku, products.image_url
              FROM order_items
              JOIN products ON order_items.product_id = products.id
              WHERE order_items.order_id = ?";

$stmt_items = $conn->prepare($sql_items);
$stmt_items->bind_param("i", $order_id);
$stmt_items->execute();
$result_items = $stmt_items->get_result();

$order_items = [];
while ($row = $result_items->fetch_assoc()) {
    $order_items[] = [
        "id" => $row["id"],
        "quantity" => $row["quantity"],
        "unitPrice" => (float)$row["unit_price"],
        "totalPrice" => (float)$row["total_price"],
        "product" => [
            "id" => $row["product_id"],
            "name" => $row["product_name"],
            "sku" => $row["sku"],
            "image_url" => $row["image_url"]
        ]
    ];
}

$sql_status = "SELECT old_status, new_status, notes, created_at FROM order_status_history WHERE order_id = ?";
$stmt_status = $conn->prepare($sql_status);
$stmt_status->bind_param("i", $order_id);
$stmt_status->execute();
$result_status = $stmt_status->get_result();

$status_history = [];
while ($row = $result_status->fetch_assoc()) {
    $status_history[] = $row;
}

$sql_promocode = "SELECT promocodes.code, promocode_usage.discount_amount
                  FROM promocode_usage
                  JOIN promocodes ON promocode_usage.promocode_id = promocodes.id
                  WHERE promocode_usage.order_id = ?";

$stmt_promocode = $conn->prepare($sql_promocode);
$stmt_promocode->bind_param("i", $order_id);
$stmt_promocode->execute();
$result_promocode = $stmt_promocode->get_result();

$applied_promocode = $result_promocode->fetch_assoc();

$response = [
    "success" => true,
    "data" => [
        "order" => [
            "id" => $order["id"],
            "user" => [
                "id" => $order["user_id"],
                "name" => $order["name"],
                "email" => $order["email"],
                "mobile" => $order["mobile"]
            ],
            "orderStatus" => $order["order_status"],
            "totalAmount" => (float)$order["total_amount"],
            "shipping_charges" => (float)$order["shipping_charges"],
            "discountAmount" => (float)$order["discount_amount"],
            "paymentStatus" => $order["payment_status"],
            "paymentMethod" => $order["payment_method"],
             "cancellationReason" => $order["cancellation_reason"],
            //"trackingOrder" => $order["tracking_order"],
            "createdAt" => $order["created_at"],
            "updatedAt" => $order["updated_at"],
            "shippingAddress" => [
                "firstName" => $order["first_name"],
                "lastName" => $order["last_name"],
                "phoneNumber" => $order["phone_number"],
                "flatBuilding" => $order["flat_building"],
                "areaStreet" => $order["area_street"],
                "landmark" => $order["landmark"],
                "city" => $order["city"],
                "state" => $order["state"],
                "country" => $order["country"],
                "pincode" => $order["pincode"]
            ],
            "items" => $order_items,
            "statusHistory" => $status_history,
            "appliedPromocode" => $applied_promocode
        ]
    ]
];

echo json_encode($response);
?>
