<?php
header("Content-Type: application/json");
require '../dbconn.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id = $_POST["id"] ?? null;
    $username = $_POST["username"] ?? null;
    $email = $_POST["email"] ?? null;
    $password = $_POST["password"] ?? null;
    $role = $_POST["role"] ?? null;

    if (!$id) {
        echo json_encode(["success" => false, "message" => "Admin ID is required"]);
        exit();
    }

    if ($email && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(["success" => false, "message" => "Invalid email format"]);
        exit();
    }

    if ($role && !in_array($role, ["admin", "super_admin"])) {
        echo json_encode(["success" => false, "message" => "Invalid role"]);
        exit();
    }

    // Prepare update query
    $updates = [];
    $params = [];
    $types = "";

    if ($username) {
        $updates[] = "username = ?";
        $params[] = $username;
        $types .= "s";
    }

    if ($email) {
        $updates[] = "email = ?";
        $params[] = $email;
        $types .= "s";
    }

    if ($password) {
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);
        $updates[] = "password_hash = ?";
        $params[] = $hashed_password;
        $types .= "s";
    }

    if ($role) {
        $updates[] = "role = ?";
        $params[] = $role;
        $types .= "s";
    }

    if (empty($updates)) {
        echo json_encode(["success" => false, "message" => "No fields to update"]);
        exit();
    }

    $params[] = $id;
    $types .= "i";

    $query = "UPDATE admin SET " . implode(", ", $updates) . " WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$params);

    if ($stmt->execute()) {
        echo json_encode(["success" => true, "message" => "Admin details updated successfully"]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to update admin details"]);
    }

    $stmt->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid request method"]);
}

$conn->close();
?>
